﻿using System;

namespace CSharpBuch.Kap14
{
  class Aufgabe2
  {
    static void Main(string[] args)
    {
      DoNothingClass dnc = new DoNothingClass();
      try
      {
        dnc.DoNothingMethod();
      }
      finally
      {
        dnc.Dispose();
      }
      Console.ReadLine();
    }
  }

  class DoNothingClass : IDisposable
  {
    private bool disposeHandled = false;

    public void DoNothingMethod()
    {
      Console.WriteLine("Dumm Didel Dei ... hier passiert nix");
    }

    public DoNothingClass()
    {
      Console.WriteLine("Objekt erzeugt");
    }

    public void Dispose()
    {
      Dispose(true);
      GC.SuppressFinalize(this);
    }

    protected virtual void Dispose(bool callDispose)
    {
      if (!disposeHandled)
      {
        Console.WriteLine("Objekt freigegeben...");
        disposeHandled = true;
      }
    }

    ~DoNothingClass()
    {
      Dispose(false);
      Console.WriteLine("Destruktor von Objekt aufgerufen...");
    }
  }
}